/*------------------------------------------------------------------------------*
 * File Name: sys_utils.h				 										*
 * Creation: CPY 3/13/02														*
 * Purpose: Basic and common utilities for general Origin C development.		*
 * Copyright (c) OriginLab Corp.	2002, 2003, 2004, 2005, 2006, 2007			*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * EJP 07-10-2003 v7.0622 QA70-4745 SET_PAGE_IMPORT_INFO_ON_123_ASC_IMPORT		*
 * Frank 5/26/04  v8.0878 QA70-6418 GET_ALLUSER_FOLDEL_PATH						*
 * SY 10/13/2004 v8.0147 IMPORT_WIZARD_CLEANUP									*
 * EJP 12-20-2004 v8.0177 UTIL_FUNC_CONV_CR_TO_CRLF								*
 * DSC 2/7/05 v8.0190 CONVERT_STRING_TO_TAG_NAME								*
 * DG 3/31/05 v8.0213 REMOVE_REPEAT_ITEM_IN_VECTOR								*
 * DG 4/6/05 v8.0217 FILE_TIME_COMPARE											*
 * DSC 6/16/05 ADD_SORT_XF_LIST_OPTIONS											*
 * DG 7/18/05 QA70-6599 v8.0270 IS_REPEATE_STR									*
 * EJP 2005-10-06 v8.0314 ADD_GETOPENBOX_WITH_GROUP_NAME						*
 * Frank 10/17/06 ADD_DOUBLE_OUTPUR_FORMAT_IN_TREE_OUT							*
 * EJP 2006-01-27 v8.0362 QA70-7921 MULTI_FILE_IMPORT_WITH_XF					*
 * EJP 2006-02-17 v8.0366 MOVE_IMPORT_FILE_INFO_FROM_OC_TO_VC					*
 * Joe 6/26/06  ADD_STR_SEPARATE                                                *
 * SY 2006-10-02 v8.0493 QA70-9015 XF_THEME_BOOK_AND_SHEET						*
 * Jasmine 10/13/06 GET_FILE_EXT_DESC											*
 * Cheney 2006-11-10 MOVE_IS_EMPTY_OR_UNASSIGN_FROM_EXPASC						*
 * Jasmine 12/12/06 FIND_CONTIGUOUS_RANGE										*
 *  Justin on 03/30/2007 MODIFY_FUNCTION_CATEGORY								*
 *	Jake 05/23/07 GET_SAVE_PATH_FROM_ORIGIN_INI									*
 * EJP 2007-05-30 v8.0631 QA70-9796 OC_ACCESS_TO_FDLOG							*
 *	Folger 06/13/07 SET_FILE_GROUP_DEFAULT_PATH									*
 * Jake 06/18/07 v8.0643 GET_PATH_TRACK_LIST_FROM_REGISTRY						*
 * Jake 06/18/07 v8.0643 UPDATE_PATH_TRACK_LIST_TO_REGISTRY						*
 * Sim 06-18-2007 ADD_SHOW_DLG_CHECK_BOX_TO_SAVE_AS_DLG							*
 * Jake 06/19/07 v8.0644 CONVERT_PREDEFINED_PATH_TO_REAL_PATH					*
 * Sim 07-17-2007 IMPROVE_FILTER_SETTING_FUNC									*
 *	Hong 08/14/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP	*
 * Folger 08/21/07 ADD_FILE_PATH_PARAM_TO_SPECIFY_GROUP_PATH					*
 * Folger 08/21/07 REMOVE_ONE_LINE_FROM_FILTER_INI_SETTING						*
 * Folger 08/23/07 COMPARE_TWO_FILES_MODIFIED_TIME								*
 * Folger 09/04/07 USE_FILE_LAST_MODIFIED_COMPARE_OF_VC_LEVEL					*
 *	CPY 12/26/07 QA70-10870 NUMERIC_INPUT_BOX_NEEDED							*
 *	Folger 01/14/08 GET_ORIGIN75_SYSTEM_FILE_PATH								*
 *	Folger 01/18/08 SHOULD_SORT_INPUT_VECTOR_BEFORE_FIND_CONTIGUOUS_RANGE		*
 * EJP 2008-01-23 v8.0792 QA70-10839 OC_CHECK_FOR_UPDATES						*
 * EJP 2008-02-05 v8.0801 QA70-11058 IW_NEED_SHOW_ALL_TEMPLATES_IN_UFF			*
 *	Folger 04/17/08 QA80-11440 SYSTEM_UTILITY_FUNCTION_TO_REFRESH_ORIGIN_MAIN_MENU
 *	Jasmine 04/29/08 ADD_FUNC_REMOVE_EMPTY_ITEM_FROM_STRING_VECTOR				*
 *	Jasmine 05/05/08 GET_ELEMENT_FROM_VECTOR_BY_ANOTHER_FILTER_VECTOT			*
 *	Folger 06/05/08 OPX_FILE_PUBLISH_SHOULD_IDENTIFY_BY_VERSION_FIRST			*
 *	Folger 08/22/08 QA80-12074 ADD_UTILITY_FUNCTION_FOR_INITIAL_TEMPLATE_LIST	*
 *	Jasmine 10/23/08 QA80-12442 SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE			*
 *	Sim 12-23-2008 QA80-12836 SUPPORT_FILE_BROWSER_BUTTON						*
 *	Kyle 01/04/2009 QA70-12890-P4 CENTRALIZE_CODE_TO_GET_AND_UPDATE_CUSTOM_DATE_FORMAT
 *	Kyle 01/05/2009 QA70-12890-P6 CUSTOM_DATE_FORMAT_LIST_DEFAULT_SHOW_STANDARD_FORMAT_IN_SQL_CONVERT
 *	Folger 03/26/09 ANALYSIS_OUTPUT_REPORT_SHEET_NAME_SHOULD_BE_EXCLAMATION_CHAR_ENDING
 *	Hong 04/07/09 QA80-13419 GET_DEBUG_VECTOR_TREENODE_DISPLAY_STRING			*
 *	Sim 05-07-2009 QA80-13571 FIX_CRASH_WHEN_FILE_PATH_LENGTH_IS_TOO_LONG		*
 *	Hong 05/18/09 QA80-13629 LT_FILE_DLG_ADD_DEFAILT_PATH_OPTION				*
 * Kenny 06/01/2009 DEFINE_SIGNIFICANT_DIGITS_MACROS_FOR_USE_OF_OC_LEVEL		*
 *	Sim 07-09-2009 QA80-13891 EXPORT_FILE_SUPPRESS_FILE_EXIST_PROMPT			*
 *	Folger 08/10/09 QA80-13998 ACTIVE_SUMMARY_BOOK_ONLY_IF_IN_ACTIVE_FOLDER		*
 *	Folger 08/27/09 QA80-14215 CHANGE_USER_FILES_FOLDER_IN_ORIGIN				*
 *	Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG									*
 *	Folger 10/21/09 QA81-14506 FAILS_TO_IMPORT_CSV_FILE_IN_SAMPLES_FOLDER_UNDER_GOS_BY_DEFAULT
 *	Folger 10/28/09 QA81-14541 SYSTEM_DEFAULT_FILE_EXTENSION_TEMP_CHANGE_SUPPORT*
 *	Folger 07/12/10 ORG-532 TRANSFER_USER_FILES_FAILED_TO_SHOW_81_FILES			*
 *------------------------------------------------------------------------------*/

#ifndef _SYS_UTILS_H
#define _SYS_UTILS_H

// Included files
#include <stdio.h>           // IO functions and string.h
#include <OC_const.h>        // MAXFULLPATH
#include <math.h>            // Mathematical functions
#include <utilities.h>       // LT_ functions
#include <complex.h>		 // For implementing the Re, Im, and Conj functions
#include <mswin.h>           // Windows API functions
#include <page.h>			 // GraphPage class

///Kenny 06/01/2009 DEFINE_SIGNIFICANT_DIGITS_MACROS_FOR_USE_OF_OC_LEVEL
#define MIN_SIGNIFICANT_DIGITS				1
#define MAX_SIGNIFICANT_DIGITS				15
///End DEFINE_SIGNIFICANT_DIGITS_MACROS_FOR_USE_OF_OC_LEVEL

// Enumerated definitions
typedef enum { FDLOG_ORIGIN = 1, FDLOG_EXCEL, FDLOG_TEMPLATE, FDLOG_ASCII, FDLOG_LOTUS, FDLOG_IMPORT_EXCEL,
	FDLOG_DBASE, FDLOG_DIF, ORIGIN_LABTECH, FDLOG_SOUND, FDLOG_MATHEMATICA, FDLOG_KALEIDAGRAPH,
	FDLOG_IMAGE, FDLOG_CSV, FDLOG_PCLAMP, FDLOG_SCRIPT, FDLOG_NOTES, FDLOG_EDITOR, FDLOG_SIGMA_PLOT,
	FDLOG_ODAQ, FDLOG_THERMO_GALACTIC_SPC, FDLOG_MINI_TAB,
	FDLOG_FILTER_ASCII=10000, FDLOG_FILTER_BINARY, FDLOG_FILTER_USERDEFINED } FDLogUseGroup;
	 
typedef enum { FDLOG_TYPE_SAVE_AS = 0, FDLOG_TYPE_OPEN_SINGLE, FDLOG_TYPE_OPEN_MULTISEL,
	FDLOG_TYPE_MULTI_OPEN } FDLogDialogType;

///---Sim 07-17-2007 IMPROVE_FILTER_SETTING_FUNC
/*
//---Jake 07/12/07 GET_AND_SET_FILTER_SETTING
enum
{
	FILTER_SETTING_DRAG_AND_DROG = 0,
};
//---end GET_AND_SET_FILTER_SETTING
*/
///---END IMPROVE_FILTER_SETTING_FUNC

// FDLog Multi-Selection/Multi-Open options
#define FDLOG_MULTI_OPEN_MULTI_SELECTION_ONLY	-1
#define FDLOG_MULTI_OPEN_SHOW_COL_DESIG			1
#define FDLOG_MULTI_OPEN_SHOW_TEMPLATE			2
#define FDLOG_MULTI_OPEN_SHOW_FILE_SIZE			4
#define FDLOG_MULTI_OPEN_SHOW_MODIFY			8

#define FILENAME_RESTRICTION "/\\?*:|""<>" ///---Sim 12-05-2006 CHECK_VALID_FILE_NAME /\?*:|"<>

// Function prototypes
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:BrowseGetPath_(global_function)
*/
string BrowseGetPath( LPCSTR lpcszPath = NULL, LPCSTR lpcszDialogName = NULL );

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetOpenBox_(global_function)
*/
string GetOpenBox( StringArray &saFiletypes, LPCSTR lpcszPath = NULL, LPCSTR lpcszFilename = NULL,
	 LPCSTR lpcszDialogName = NULL );

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetOpenBox_(global_function)
*/
string GetOpenBox( FDLogUseGroup nFDLogUseGroup, LPCSTR lpcszPath = NULL, LPCSTR lpcszFilename = NULL,
	 LPCSTR lpcszDialogName = NULL );

/// EJP 2005-10-06 v8.0314 ADD_GETOPENBOX_WITH_GROUP_NAME
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetFDLogBox_(global_function)
*/
/// Hong 05/18/09 QA80-13629 LT_FILE_DLG_ADD_DEFAILT_PATH_OPTION
//int GetFDLogBox(StringArray &saFilePaths, FDLogDialogType fdtDialogType, BOOL bUseTemplate = FALSE);	
int GetFDLogBox(StringArray &saFilePaths, FDLogDialogType fdtDialogType, BOOL bUseTemplate = FALSE, LPCSTR lpcszPath = NULL);
/// end LT_FILE_DLG_ADD_DEFAILT_PATH_OPTION
/// end XF_THEME_BOOK_AND_SHEET
 
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:init_fdlog_with_group_name_(global_function)
*/
bool init_fdlog_with_group_name(LPCSTR lpcszFileExtGroupName, LPCSTR lpcszPath = NULL, LPCSTR lpcszFileName = NULL, LPCSTR lpcszDialogName = NULL) ;

//-- SY 2006-10-02 v8.0493 QA70-9015 XF_THEME_BOOK_AND_SHEET
/**#
		Show a file open dialog using the specified settings.
	Parameters:
		strFile = [output] user selected file names separated by "\r\n"
		lpcszGroup = [input] name of file extension group
		lpcszTitle = [input] optional dialog title
		bMultiFiles = [input] whether allow user to select multiple files at the same time
		bUseTemplate [input] whether to show Template column in Multi-Open dialog
		lpcszDefaultPath = [input] default path, NULL will use default path of file extension group, empty will be last used path
		lpcszDefaultFilename = [input] default file name
	Example1:
		int get_open_box_by_file_group_Ex1()
		{
			string	strFile;
			LPCSTR	strGroup = "CodeBuilder";
			LPCSTR	strTitle = "OpenFileDlg";
			bool	bMultiFiles = true;
			bool	bUseTemplate = true;
			LPCSTR	strDefaultPath = "";
			LPCSTR	strDefaultFileName = NULL;
			LPCSTR	strCheckBoxName = NULL;
			int		nCheckBoxState;
			LPCSTR	strFunctionName = NULL;
		
			get_open_box_by_file_group( strFile, strGroup, strTitle, bMultiFiles, bUseTemplate, strDefaultPath, strDefaultFileName );
			out_str( "File selected : " + strFile );
			return 0;
		}
	Return:
		Number of files selected by user.

*/
int get_open_box_by_file_group(string& strFile, LPCSTR lpcszGroup, LPCSTR lpcszTitle = NULL, bool bMultiFiles = false, bool bUseTemplate = false, LPCSTR lpcszDefaultPath = NULL, LPCSTR lpcszDefaultFilename = NULL);
//---
/// end ADD_GETOPENBOX_WITH_GROUP_NAME

/// EJP 2007-05-30 v8.0631 QA70-9796 OC_ACCESS_TO_FDLOG
#define OPENBOX_FLAG_MULTIFILES			0x00000001 // Use Multi-Open dialog
#define OPENBOX_FLAG_FORCECHECKSTATE	0x00000002 // Force the use of the value in lpnCheckBoxState

// Bits used when OPENBOX_FLAG_MULTIFILES is OFF
#define OPENBOX_FLAG_MULTISEL			0x00010000 // Allow multi-file selection in non-Multi-Open dialog

// Bits used when OPENBOX_FLAG_MULTIFILES is ON
#define OPENBOX_FLAG_USETEMPLATE		0x00010000 // Show Template column in Multi-Open dialog

///---Sim 07-09-2009 QA80-13891 EXPORT_FILE_SUPPRESS_FILE_EXIST_PROMPT
#define OPENBOX_FLAG_SUPPRESSPROMPT		0x00100000 // Suppress file exist prompt ( replace warrning message box )
///---END QA80-13891 EXPORT_FILE_SUPPRESS_FILE_EXIST_PROMPT

/// Comment last updated by Hong 07/18/08 QA80-11861 FIX_FILE_GROUP_FAIL_USING_DEFAULT_PATH
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:get_open_box_by_file_group_(global_function)
*/
int get_open_box_by_file_group(
	string& strFile,
	LPCSTR lpcszGroup,
	LPCSTR lpcszTitle = NULL,
	DWORD dwFlags = 0,
	LPCSTR lpcszDefaultPath = NULL,
	LPCSTR lpcszDefaultFilename = NULL,
	LPCSTR lpcszCheckBoxName = NULL,
	int* lpnCheckBoxState = NULL,
	LPCSTR lpcszFuncName = NULL
	);
/// end OC_ACCESS_TO_FDLOG

///---Sim 06-18-2007 ADD_SHOW_DLG_CHECK_BOX_TO_SAVE_AS_DLG
/// Comment last updated by Hong 07/18/08 QA80-11861 FIX_FILE_GROUP_FAIL_USING_DEFAULT_PATH
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:get_saveas_box_by_file_group_(global_function)
*/
int get_saveas_box_by_file_group(
	string& strFile,
	LPCSTR lpcszGroup,
	LPCSTR lpcszTitle = NULL,
	DWORD dwFlags = 0,
	LPCSTR lpcszDefaultPath = NULL,
	LPCSTR lpcszDefaultFilename = NULL,
	LPCSTR lpcszCheckBoxName = NULL,
	int* lpnCheckBoxState = NULL,
	LPCSTR lpcszFuncName = NULL
	);
///---END ADD_SHOW_DLG_CHECK_BOX_TO_SAVE_AS_DLG

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetOpenBox_(global_function)
*/
string GetOpenBox( LPCSTR lpcszFileType = "*.* All Files", LPCSTR lpcszPath = NULL, LPCSTR lpcszFilename = NULL,
	 LPCSTR lpcszDialogName = NULL );

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetSaveAsBox_(global_function)
*/
string GetSaveAsBox( StringArray &saFiletypes, LPCSTR lpcszPath = NULL, LPCSTR lpcszFilename = NULL,
	 LPCSTR lpcszDialogName = NULL );

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetSaveAsBox_(global_function)
*/
string GetSaveAsBox( FDLogUseGroup nFDLogUseGroup, LPCSTR lpcszPath = NULL, LPCSTR lpcszFilename = NULL,
	 LPCSTR lpcszDialogName = NULL );

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetSaveAsBox_(global_function)
*/
string GetSaveAsBox( LPCSTR lpcszFileType = "*.* All Files", LPCSTR lpcszPath = NULL, LPCSTR lpcszFilename = NULL,
	 LPCSTR lpcszDialogName = NULL );

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ran_(global_function)
*/
double ran(int nSeed = 0);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetClipboardText_(global_function)
*/
BOOL GetClipboardText( string& strData );

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetTempFileName_(global_function)
*/
BOOL GetTempFileName(string &strFile, LPCSTR lpcszPrefix = NULL);

/// EJP 2008-01-23 v8.0792 QA70-10839 OC_CHECK_FOR_UPDATES
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetFileModificationDate_(global_function)
*/
BOOL GetFileModificationDate(LPCSTR lpcstrPathAndFilename, SYSTEMTIME& pSysTime);
/// end OC_CHECK_FOR_UPDATES

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetFileModificationDate_(global_function)
*/
string GetFileModificationDate(LPCSTR lpcstrPathAndFilename, WORD wFormat=LDF_SHORT);

// Comments last updated by Joseph on 9/11/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:FindFiles_(global_function)
*/
BOOL FindFiles(StringArray& saResult, LPCSTR lpcszPath, LPCSTR lpcszFileOrExt=NULL, bool bCheckExist = false);

// Comments last updated by Frank on 8/16/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:FileCopy_(global_function)
*/
BOOL FileCopy(LPCSTR lpcszSrc, LPCSTR lpcszDest, DWORD dwAttribute = FILE_ATTRIBUTE_NORMAL, bool bSetCurrentTime = false);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:export_page_(global_function)
*/
bool export_page(Page &pg, LPCSTR lpcszFileName, const TreeNode &trExport);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:export_page_(global_function)
*/
bool export_page(Page &pg, LPCSTR lpcszFileName, LPCSTR lpcszFormat = "EPS");

// Comments last updated by Frank on 8/16/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:export_page_to_image_(global_function)
*/
bool export_page_to_image(Page &pg, LPCSTR lpcszFileName, LPCSTR lpcszFormat, BOOL bShowOptions=FALSE);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:export_page_to_image_(global_function)
*/
bool export_page_to_image(LPCSTR lpcszFileName, LPCSTR lpcszFormat, Page &pg, int nWidth, int nHeight, int nBitsPerPixel, int nCompression=0, bool bGrayScale=false);

//------------------- GJL v7.0357 QA70-4078 3/17/03 ORIGINC_MULTI_OPEN_SUPPORT
//////////////////////////////////////////////////////////////////////////////////
// Comments last updated by Frank on 8/16/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetMultiOpenBox_(global_function)
*/
int GetMultiOpenBox( StringArray& saFilePaths, StringArray &saFiletypes, LPCSTR lpcszPath = NULL, LPCSTR lpcszFilename = NULL,
	 LPCSTR lpcszDialogName = NULL, bool bMultiSelection = true );

// Comments last updated by Frank on 8/16/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetMultiOpenBox_(global_function)
*/
int GetMultiOpenBox( StringArray& saFilePaths, FDLogUseGroup nFDLogUseGroup, LPCSTR lpcszPath = NULL, LPCSTR lpcszFilename = NULL,
	 LPCSTR lpcszDialogName = NULL, bool bMultiSelection = true);

//////////////////////////////////////////////////////////////////////////////////
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetMultiOpenBox_(global_function)
*/
int GetMultiOpenBox( StringArray& saFilePaths, LPCSTR lpcszFileType = NULL, LPCSTR lpcszPath = NULL, LPCSTR lpcszFilename = NULL,
	 LPCSTR lpcszDialogName = NULL, bool bMultiSelection = true );
//------------------- QA70-4078

/**#
		Compute a LabTalk (1 based) index from a C (0 based) index and add an offset.
	Parameters:
		iCindex=[input] 0 based C index
		nOffset=[input] offset, default is 0
	Return:
		Returns a LabTalk 1 based index with added offset.
*/
int c_index_to_labtalk_index(int iCindex, int nOffset = 0);

/**#
		Compute a C (0 based) index from a LabTalk (1 based) index and add an offset.
	Parameters:
		iLTindex=[input] 1 based LabTalk index
		nOffset=[input] offset, default is 0
	Return:
		Returns a C 0 based index with added offset.
*/
int labtalk_index_to_c_index(int iLTindex, int nOffset = 0);



/**#
*/
BOOL	worksheets_are_same(Worksheet &wks1, Worksheet &wks2, bool bCheckSheetName = true);


/**#
*/
int FDLogInit();

/**#
*/
bool validate_identifier_name(string &strName);

/**# >Note Window
*/
bool	get_create_Note(string &strNoteWnd);

// Comments last updated by Frank on 8/16/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:append_blanks_to_size_(global_function)
*/
void	append_blanks_to_size(string &str, int nSize);

/// EJP 2006-02-17 v8.0366 MOVE_IMPORT_FILE_INFO_FROM_OC_TO_VC
///	/// EJP 07-10-2003 v7.0622 QA70-4745 SET_PAGE_IMPORT_INFO_ON_123_ASC_IMPORT
///	/** >Import Export
///		Set the page.info.import properties.
///		Parameters:
///			pgTarget = reference to the page that will receive the import info
///			lpcszFile = pointer to the name of the file imported
///			iDataType = the type of data
///		Return:
///			TRUE for success, FALSE for failure
///	*/
///	BOOL set_page_import_info(Page &pgTarget, LPCSTR lpcszFile, int iDataType);
///	/// end SET_PAGE_IMPORT_INFO_ON_123_ASC_IMPORT
/// end MOVE_IMPORT_FILE_INFO_FROM_OC_TO_VC

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:add_file_extension_(global_function)
*/
bool add_file_extension(string& strFilename, LPCSTR lpcszExt);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:get_next_file_name_(global_function)
*/
bool get_next_file_name(string& strFilename, bool bCheckCreatePath = true, bool bKeepPostfixFormat = true);

// Comments last updated by Sim on 11-30-2006
// Comments last updated by Frank on 8/16/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:is_str_valid_for_filename_(global_function)
*/
//bool is_str_valid_for_filename(LPCSTR lpcszFilename);	///DG REMOVE_REPEAT_ITEM_IN_VECTOR
bool is_str_valid_for_filename(string &strName, bool bAutoCorrect=false);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:is_repeat_str_(global_function)
*/
int is_repeat_str(string str);

///Jasmine 04/29/08 ADD_FUNC_REMOVE_EMPTY_ITEM_FROM_STRING_VECTOR
/**$ 
	Remarks: remove empty or space only items in a string vector
	Parameters:
		vs = [input/output]
	Return:
		size of vs after removing
*/
int	remove_empty_item(vector<string>& vs);
///End ADD_FUNC_REMOVE_EMPTY_ITEM_FROM_STRING_VECTOR

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:find_prefix_char_number_(global_function)
*/
int find_prefix_char_number(const string& str, char ch);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:find_end_char_number_(global_function)
*/
int find_end_char_number(const string& str, char ch);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:count_list_(global_function)
*/
int count_list(const vector<string>& vsList, vector<string>& vsUnique, vector<uint>& vnCounts, bool bCaseSensitive = false);



/**+
http://ocwiki.originlab.com/index.php?title=OriginC:count_list_(global_function)
*/
bool count_list(const vector<string>& vsList, vector<int>& vnIndices, bool bCaseSensitive = false);

// Comments last updated by Frank on 8/16/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:is_in_list_(global_function)
*/
bool is_in_list(LPCSTR lpcszName, const vector<string>& vsList, bool bCaseSensitive = false, int* pn = NULL);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:find_in_list_(global_function)
*/
string find_in_list(double dVal, const string& strList, char cSeparator = '|');

//Comments last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:find_in_list_(global_function)
*/
int find_in_list(int nVal, const vector<int>& vn, bool bWasSortedAccending);

///DG REMOVE_REPEAT_ITEM_IN_VECTOR
// Comments last updated by Frank on 8/16/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:remove_repeat_item_(global_function)
*/
void remove_repeat_item(vector<string> &vsList, bool bRemoveEmpty=true, bool bCaseSensitive=false);
///end REMOVE_REPEAT_ITEM_IN_VECTOR

//Comments last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:remove_if_not_in_list_(global_function)
*/
int remove_if_not_in_list(vector<string>& vsToCheck, const vector<string>& vsList, bool bCaseSensitive = false);

// Comments last updated by Frank on 8/19/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:remove_if_in_list_(global_function)
*/
int remove_if_in_list(vector<string>& vsToCheck, const vector<string>& vsList, bool bCaseSensitive = false);

/// Comments last updated by Cloud on 03/20/2007
/**# >Character/String Manipulation
*/
///Hong 8/01/06 ADD_POSTFIX_SUPPORT
//int get_list_enum_number(vector<string> vsVals, string strPrefix);
int get_list_enum_number(vector<string> vsVals, string strPrefix, string strPostfix = "");
///end ADD_POSTFIX_SUPPORT

/// Comments last updated by Cloud on 03/20/2007
/**# >Character and String Manipulation
*/
///Sophy 4/9/2008 SET_STR_INSERT_LIST_CASE_SENSITIVE_CONTROL
//bool insert_str_to_str_list(LPCSTR lpcszInsert, string& strList, LPCSTR lpcszBefore = NULL, string strDelimiter = "|");
bool insert_str_to_str_list(LPCSTR lpcszInsert, string& strList, LPCSTR lpcszBefore = NULL, bool bFullMatch = true, string strDelimiter = "|");
///end SET_STR_INSERT_LIST_CASE_SENSITIVE_CONTROL
// Comments last updated by Frank on 8/19/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:remove_str_from_str_list_(global_function)
*/
///Sophy 04/09/2008 SET_REMOVE_STRING_CASE_SENSITIVE
//bool remove_str_from_str_list(LPCSTR lpcszRemoved, string& strList, string strDelimiter= "|"); 
bool remove_str_from_str_list(LPCSTR lpcszRemoved, string& strList, bool bFullMatch = true, string strDelimiter= "|"); 
///end SET_REMOVE_STRING_CASE_SENSITIVE
//Comments last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:get_str_from_str_list_(global_function)
*/
string get_str_from_str_list(string& strList, string strDelimiter, uint nIndex =0 );

///Jasmine 05/05/08 GET_ELEMENT_FROM_VECTOR_BY_ANOTHER_FILTER_VECTOT
/**$
	Remarks: remove element from vec according to vbFiltor
	Parameters:
		vec = [input/output]vector to be trimed
		vbFiltor = [input]the filter vector. If vec[index] will be removed if vbFiltor[index] is false or index exceeds vbFiltor's size
	Return:
		size of vec after removing
*/
int trim_vector(vectorbase& vec, const vectorbase& vbFiltor);
///End GET_ELEMENT_FROM_VECTOR_BY_ANOTHER_FILTER_VECTOT

/// Comments last updated by Joseph on 05/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:get_system_font_name_(global_function)
*/
string get_system_font_name(int nType = ANSI_VAR_FONT, int* lpnCharSet = NULL);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:is_win2k_(global_function)
*/
bool is_win2k(bool bAndLater = true);


/**+
http://ocwiki.originlab.com/index.php?title=OriginC:is_pro_version_(global_function)
*/
bool is_pro_version();

///Frank 5/26/04  v8.0878 QA70-6418 GET_ALLUSER_FOLDEL_PATH						
/**#
		get the all user folder path, if you set bCreateIfNoExist = true will create the folder if not exist
	Parameters:
		bCreateIfNoExist = [input] true to create the folder if not exist.
	Returns:
		path of all user folder, if not exist return "".
 */
// string get_alluserfolder_path(bool bCreateIfNoExist = false);///DSC 2/17/05 GET_ORIGIN_PATH
///End    GET_ALLUSER_FOLDEL_PATH


//---- CPY 5/6/04 QA70-6367 HISTOGRAM_GRAPHS
/**#
// replace return false with this function to allow error message to directly display
*/
bool error_report(LPCSTR lpcszErrMsg, bool bCriticalErr=false);
//----
///Frank 9/14/04  v8.0131 QA70-6903 PAD_CHAR_TO_STRING	

// Comments last updated by Frank on 8/19/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:str_pad_char_(global_function)
*/
string	str_pad_char(LPCSTR lpcstr, int nTotalLength, int nPaddingFormat, char	chPading = ' ');
///End PAD_CHAR_TO_STRING	

///DG FILE_TIME_COMPARE
enum {
	//These values are used to specify the file time to compare:
	CREATION_TIME,
	LAST_ACCESS_TIME,
	LAST_WRITE_TIME,
};

// Comments last updated by Joseph on 9/11/2007
// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:file_time_compare_(global_function)
*/
int file_time_compare(LPCSTR lpczFile1, LPCSTR lpczFile2, DWORD dwOption = CREATION_TIME);
///end FILE_TIME_COMPARE

/// SY 10/13/2004 v8.0147 IMPORT_WIZARD_CLEANUP
#if _OC_VER >= 0x0800

///Frank 9/23/04  v8.0137 QA70-6027 CONVERT_NUM_TO_STRING_VECTOR
//Comments last updated by Joseph on 2007.5.22
// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:convert_tree_double_vector_to_str_vector_(global_function)
*/
int convert_tree_double_vector_to_str_vector(const TreeNode& trVec, vector<string>& vs, uint nSize, string strFmt = "*");

/// Iris 10/12/05 ADD_SIGNIFICANT_DIGITE
//Comments last updated by Joseph on 2007.5.22
// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:convert_tree_double_vector_to_str_vector_(global_function)
*/
int convert_tree_double_vector_to_str_vector(const TreeNode& trVec, vector<string>& vs, const vector<int>& vnSignDigites = NULL);
///End ADD_SIGNIFICANT_DIGITE

//Comments last updated by Joseph on 2007.5.22
// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:convert_str_vector_to_num_vector_(global_function)
*/
int convert_str_vector_to_num_vector(const vector<string>& vs, vector<double>& vd);
/**$
*/
void str_vector_to_double_vector_treenode(TreeNode& tr, const vector<string>& vs);

//Comments last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:init_vector_string_(global_function)
*/
void init_vector_string(vector<string> &vsEmptyVec, int nSize, string strDefault = "");
///End CONVERT_NUM_TO_STRING_VECTOR
///Frank 10/27/04 v8.0156  MATRIX_OR_VECTOR_TREENODE_OUTPUT_STRING
///Frank 10/17/06 ADD_DOUBLE_OUTPUR_FORMAT_IN_TREE_OUT
//Comments last updated by Joseph on 2007.5.22
// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:convert_double_vector_to_string_vector_(global_function)
*/
//int convert_double_vector_to_string_vector(const vector<double>& vd, vector<string>& vs, uint nSize, LPCSTR lpcstrFormat = NULL );
int convert_double_vector_to_string_vector(const vector<double>& vd, vector<string>& vs, uint nSize, vector<string> &vsFormat = NULL );
///End ADD_DOUBLE_OUTPUR_FORMAT_IN_TREE_OUT
///End  MATRIX_OR_VECTOR_TREENODE_OUTPUT_STRING

/// Iris 10/12/05 ADD_SIGNIFICANT_DIGITE
///Frank 10/17/06 ADD_DOUBLE_OUTPUR_FORMAT_IN_TREE_OUT
//int convert_double_vector_to_string_vector(const vector<double>& vd, vector<string>& vs, const vector<int>& vnSignDigites = NULL);
///End ADD_DOUBLE_OUTPUR_FORMAT_IN_TREE_OUT
///End ADD_SIGNIFICANT_DIGITE

// Category last updated by Justin on 03/26/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ReadFileLines_(global_function)
*/
int ReadFileLines(StringArray &saLines, LPCSTR lpcszFile, uint iNumLines=0, uint iFirstLine=0, uint iSkipLines=0);

//
#define GFIF_NO_ERROR			0
#define GFIF_NO_FILES_FOUND_ERROR	-1

#define GFIF_FILE_WITH_PATH		0x0000
#define GFIF_FILE_NO_PATH		0x0001
#define GFIF_FILE_NO_EXT		0x0002
/// EJP 2008-02-05 v8.0801 QA70-11058 IW_NEED_SHOW_ALL_TEMPLATES_IN_UFF
#define GFIF_FILE_RECURSIVE		0x0004 // search sub-folders
#define GFIF_STRIP_START_PATH	0x0008 // strip starting path but not sub-folders

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetFileNames_(global_function)
*/
int GetFileNames(
	StringArray& saFileNames,
	LPCSTR lpcszPath,
	LPCSTR lpcszFileSpec,
	DWORD dwCtrl);
/// end IW_NEED_SHOW_ALL_TEMPLATES_IN_UFF

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetFilenamesInFolder_(global_function)
*/
int GetFilenamesInFolder(
	string& strListOfFilenames,
	LPCSTR lpcstrPath = "",
	LPCSTR lpcstrFileFilter = "",
	BOOL bRecursive = FALSE,
	UINT wDisplayOptions = GFIF_FILE_WITH_PATH);


////////////////////////////////////////////////////////////////////////////////////
// File related functions
////////////////////////////////////////////////////////////////////////////////////
//
// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetSystemFiles_(global_function)
*/
BOOL GetSystemFiles(StringArray& saResult, LPCSTR lpcszExt);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetFilenameWithoutExt_(global_function)
*/
string GetFilenameWithoutExt( string strPathAndFilename );

//Commetnts last updated by Joseph on 2007.9.11
/**$ >Internal Origin Objects>Graph
		Builds a list of the layer numbers in the active graph. The list is returned
		as a series of tokens separated by the | character. The active layer number
		is also returned.
	Example:
	int GetLayerNumbers_ex1()
	{
		string str;
		int iActive;
		iActive = GetLayerNumbers(str);
		return 0;
	}
	Return:
		Returns a list of the layer numbers in the active graph as a series of tokens
		separated by the | character. The layer number of the active layer is returned
		on success and -1 is returned on failure.
*/
/*
int GetLayerNumbers(string& strLayerNumbers);
*/
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:LoadTextFile_(global_function)
*/
int LoadTextFile(string &strText, LPCSTR lpcszFile, uint iNumLines = 0, uint iFirstLine = 0, uint iSkipLines = 0);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:GetFileSize_(global_function)
*/
///DSC 8/4/05 NEED_FILE_SIZE_IN_BYTES
// string GetFileSize(string strPathAndFilename);
string GetFileSize(string strPathAndFilename, uint* pnBytes=NULL);
///end NEED_FILE_SIZE_IN_BYTES

/**$
*/
bool OpenExistingFile(file& filSrc, LPCSTR lpcszFile, UINT nOpenFlags);

// Comments last updated by Frank on 8/19/2005
/**#
parameters:
	b1=[input]
	b2=[input]
Example1()
	int XOR_ex1()
	{
		bool bTest1=true,bTest2=false;
		if(XOR(bTest1, bTest2))
			printf("true\n");
		else
			printf("false\n");
		return 0;
	}
Return:
	returns TRUE if b1 is diffrent from b2, FALSE if the same.
*/
BOOL XOR(bool b1, bool b2);

/// EJP 12-20-2004 v8.0177 UTIL_FUNC_CONV_CR_TO_CRLF
// Comments last updated by Iris on 03/13/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:check_convert_CR_str_to_CRLF_(global_function)
*/
bool check_convert_CR_str_to_CRLF(string& str);
/// end UTIL_FUNC_CONV_CR_TO_CRLF


///DSC 2/7/05 v8.0190 CONVERT_STRING_TO_TAG_NAME
// remove characters not allowed in tag name
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:cvt_str_to_tag_name_(global_function)
*/
string cvt_str_to_tag_name(LPCTSTR lpcszStr);
///end CONVERT_STRING_TO_TAG_NAME


/**$
*/
///Joseph 05/09/07 NOT_USE_THIS_FUNCTION_ANY_MORE
/*
/// Frank 1/22/05 v8.0185c  FUNCTION_FINDFOLDER_TO_TREENODE_OR_VECTOR
int FindFolders(TreeNode &tr, LPCSTR lpcszPath, bool bRecursive=false, string strTagnamePrefix = "", int nSubFolderLevel = 0);
*/
///End NOT_USE_THIS_FUNCTION_ANY_MORE

// Comments last updated by Frank on 8/19/2005
/**$
	find out all folders in a disk path
Parameters:
	vsFolderName=[output] holds for the name of the folders after function call.
	lpcszPath=[input] sepecify the disk path
Return:
	number of folders.
Example1:
	void FindFolders_ex1()
	{
		vector<string> vsFolderName;
		LPCSTR lpcszPath = "c:\\";
		int iNumFolder;
		iNumFolder = FindFolders(vsFolderName, lpcszPath);
		for( int ii=0; ii<iNumFolder; ii++)
			printf("%s\n", vsFolderName[ii]);
	}
*/

///Joseph 05/09/07 NOT_USE_THIS_FUNCTION_ANY_MORE
/*
int FindFolders(vector<string> &vsFolderName, LPCSTR lpcszPath);
*/
///End NOT_USE_THIS_FUNCTION_ANY_MORE

///End  FUNCTION_FINDFOLDER_TO_TREENODE_OR_VECTOR


//Comments last updated by DSC on 2/16/05
/**
		Returns the full path to System, Group or User folder, plus a subfolder if desired.
	Paramaters:
		nPathType=[input] one of the constants in the enum ORIGIN_PATH_TYPE
		lpcszSubFolder = (NULL by default) this is appended to the path if not NULL. Leave off final backslash. It will be added.
	Example1:
		void get_origin_path_ex1()
		{	
			string strUserThemePath, strUserThemeSubPath, strSystemThemePath;
			strFunction = get_origin_path(ORIGIN_PATH_USER, "Theme");
			strThemeSubPath = get_origin_path(ORIGIN_PATH_USER, "Theme\\Subpath");
			strSystemThemePath = get_origin_path(ORIGIN_PATH_SYSTEM, "Theme");
		}
	Return:
		Return full path with final backslash to the desired Origin folder.
*/
// string get_origin_path(int nPathType, string strSubPath = "");
// moved to okutil: string get_origin_path(int nPathType, LPCSTR lpcszSubPath=NULL);
// #define get_origin_path		okutil_get_origin_path



///Forest 3/3/05 ADD_FUNCTION_TO_GET_ORIGINC_TYPE_LIST

// Comments last updated by Frank on 8/19/2005
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:get_origin_c_data_types_(global_function)
*/
int get_origin_c_data_types(vector<string>& vsDataTypes);
///End ADD_FUNCTION_TO_GET_ORIGINC_TYPE_LIST

#define STR_EVENT_XF "Event X-Functions"
void set_reg_value(LPCSTR lpcszRegPath, LPCSTR lpcszDataName, LPCSTR lpcszDataValue, int nHEKY = HKEY_CURRENT_USER);
string get_reg_value(LPCSTR lpcszRegPath, LPCSTR lpcszKeyName, int nHEKY = HKEY_CURRENT_USER);



///DSC 6/16/05 ADD_SORT_XF_LIST_OPTIONS

//-- moved from analysis_utils.c
///DSC 3/23/05 v8.0209 QA70-7518 LIST_XF
// lpcszName x-function name, or can be a wildchar like "m*fn", details of wildchar can be all handled by str.Match
// list xf by
// xfname varName1 varName2
//
enum{
	LIST_XF_ARG_NAME = 0x1,
	LIST_XF_ARG_TYPES = 0x2,
	LIST_XF_ARG_DEFAULTS = 0x4,
	LIST_XF_LOCATION = 0x1000,
	LIST_XF_CATEGORY = 0x2000,
	///DSC 6/16/05 ADD_SORT_XF_LIST_OPTIONS
	LIST_XF_SORT_DISPLAY = 0x10,
	LIST_XF_SORT_NAME = 0x20,
	//LIST_XF_SHOW_DUPLICATES = 0x0100,
	LIST_XF_REMOVE_DUPLICATES = 0x0100,
	///end ADD_SORT_XF_LIST_OPTIONS
	
	LIST_XF_ARG_MORE_INFO = 0x0200,
	
	LIST_XF_SHOW_HELP = 0x0400,
	
	LIST_XF_SHOW_BRIEF_INFO = 0x0800,
	
	LIST_XF_REFRESH_LIST = 0x4000,
};
#define LIST_XF_ARG_MASK 	0x000F
#define LIST_XF_PATH_MASK 	0xF000
#define LIST_XF_SORT_MASK 	0x00F0

/**$
*/
void sort_composite_name_vs(vector<string>& vsNames, DWORD dwListOptions=LIST_XF_SORT_DISPLAY, DWORD dwStandardOptions=SORT_ASCENDING | SORT_NUMERIC_SUFFIX);
///end ADD_SORT_XF_LIST_OPTIONS

////////////////////////////  MOVE_TO_OKUTIL_DLL  /////////////////////////////////////		
////////////////////////////  MOVE_TO_OKUTIL_DLL  /////////////////////////////////////		
////////////////////////////  MOVE_TO_OKUTIL_DLL  /////////////////////////////////////		
////////////////////////////  MOVE_TO_OKUTIL_DLL  /////////////////////////////////////		
////////////////////////////  MOVE_TO_OKUTIL_DLL  /////////////////////////////////////		
////////////////////////////  MOVE_TO_OKUTIL_DLL  /////////////////////////////////////		
////////////////////////////  MOVE_TO_OKUTIL_DLL  /////////////////////////////////////		
///DSC 3/9/05 QA70-7479 MOVE_TO_OKUTIL_DLL

//Comments last updated by DSC on 2/21/05
/**
		construct a filepath string given nFileType (enum ORIGIN_PATH_TYPE), subfolder, name and extension. This function will check
		if nPathType is different from ORIGIN_PATH_USER to see if it actually exist and different from ORIGIN_PATH_USER, it will return
		true only if nPathType points to a path that is equal to ORIGIN_PATH_USER, or the path type exist and should be used 
	Paramaters:
		nPathType = [input] one of the constants in the enum ORIGIN_PATH_TYPE
		lpcszSubFolder = [input] an optional subfolder "FitFunc\\ABC", or NULL. Leave off final backslash. It will be added.
		lpcszFileName = [input] file name with or without extension, if with extension, then lpcszExt must be NULL
		lpcszExt = [input] file extension including dot: .ext
		bCheckExist = [input] if specified path and file can be constructed, then set this to true will further test if file actually existed
	Example1:
		void make_file_path()
		{	
			string strFilePath;
			make_file_path(strFilePath, ORIGIN_PATH_USER, "FitFunc", "abc", ".fdf");
		}
	Return:
		true if full path is constructed and exists (if bCheckExist), false if given nPathType does not exist or not needed or if bCheckExist and file not found
*/
//bool okutil_make_file_path(string& strFilePath, int nPathType, LPCSTR lpcszSubFolder, LPCSTR lpcszFileName, LPCSTR lpcszExt = NULL, bool bCheckExist = true);
//bool okutil_make_file_path(string* pstrFilePath, int nPathType, LPCSTR lpcszSubFolder, LPCSTR lpcszFileName, LPCSTR lpcszExt = NULL, bool bCheckExist = true);


////////////////////////////  MOVE_TO_OKUTIL_DLL  /////////////////////////////////////		
////////////////////////////  MOVE_TO_OKUTIL_DLL  /////////////////////////////////////		
////////////////////////////  MOVE_TO_OKUTIL_DLL  /////////////////////////////////////		
///DSC 3/9/05 QA70-7479 MOVE_TO_OKUTIL_DLL
/*
//Comments last updated by DSC on 2/21/05
/##
		construct a filepath string given nFileType (enum ORIGIN_PATH_TYPE), subfolder, name and extension. This function will check
		if nPathType is different from ORIGIN_PATH_USER to see if it actually exist and different from ORIGIN_PATH_USER, it will return
		true only if nPathType points to a path that is equal to ORIGIN_PATH_USER, or the path type exist and should be used 
	Paramaters:
		nPathType = [input] one of the constants in the enum ORIGIN_PATH_TYPE
		lpcszSubFolder = [input] an optional subfolder "FitFunc\\ABC", or NULL. Leave off final backslash. It will be added.
		lpcszFileName = [input] file name with or without extension, if with extension, then lpcszExt must be NULL
		lpcszExt = [input] file extension including dot: .ext
		bCheckExist = [input] if specified path and file can be constructed, then set this to true will further test if file actually existed
	Example1:
		void make_file_path()
		{	
			string strFilePath;
			make_file_path(strFilePath, ORIGIN_PATH_USER, "FitFunc", "abc", ".fdf");
		}
	Return:
		true if full path is constructed and exists (if bCheckExist), false if given nPathType does not exist or not needed or if bCheckExist and file not found
#/
//bool okutil_make_file_path(string& strFilePath, int nPathType, LPCSTR lpcszSubFolder, LPCSTR lpcszFileName, LPCSTR lpcszExt = NULL, bool bCheckExist = true);
bool okutil_make_file_path(string* pstrFilePath, int nPathType, LPCSTR lpcszSubFolder, LPCSTR lpcszFileName, LPCSTR lpcszExt = NULL, bool bCheckExist = true);
*/





/**$
*/
bool	assign_HWND_to_PHWND(LPVOID lpDest, HWND hwnd);

/// Comments last updated by Cloud on 03/20/2007
/**$ >Date Time

*/
void get_current_time(SYSTEMTIME& systime, bool bConvertToLocalTime = true);




#endif //_OC_VER >= 0x0800
/// end IMPORT_WIZARD_CLEANUP

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:page_type_2_int_(global_function)
*/
int	page_type_2_int(string strType);

/// EJP 2006-01-27 v8.0362 QA70-7921 MULTI_FILE_IMPORT_WITH_XF
/**$
	Convert a string array of file names into a single string.
	The destination string will have the file names quoted and separated by "\r\n".
	
	Parameters:
		strDst = [output] The string to receive all the file names.
		saSrc = [input] The string array containing all the file names.
*/
void file_name_array_to_str(string& strDst, const StringArray& saSrc);
/// end MULTI_FILE_IMPORT_WITH_XF

/// Iris 6/05/06 SET_WORK_DIR_AS_HISTORY_SAVE_PATH
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:get_current_working_directory_(global_function)
*/
string get_current_working_directory();
///End SET_WORK_DIR_AS_HISTORY_SAVE_PATH

///Joe 6/26/06  ADD_STR_SEPARATE
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:str_separate_(global_function)
*/
int str_separate(LPCSTR lpcszStr, LPCSTR lpcszSep, vector<string>& vsSections); 
///End ADD_STR_SEPARATE
///Joe 8/24/06 ADD_STR_COMBINE_BY_TOKENS
//Comments last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:str_combine_(global_function)
*/
///Joseph 05/25/07 SHOULD_USE_REFERENCE_ON_TRANSFOR_BIG_OBJECT
//string str_combine(vector<string> vsSource, LPCSTR lcpszSep);
string str_combine(const vector<string>& vsSource, LPCSTR lpcszSep);
///End SHOULD_USE_REFERENCE_ON_TRANSFOR_BIG_OBJECT

///End ADD_STR_COMBINE_BY_TOKENS

//---- CPY 10/25/06 BETTER_SEPARATE_FILE_NAME_AND_EXT
//void separate_file_name_ext(string& strFileName, string& strExt);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:separate_file_name_ext_(global_function)
*/
bool separate_file_name_ext(LPCSTR lpcszFilename, string* pstrFileName = NULL, string* pstrExt = NULL);

/// Iris 7/20/06 GET_IMAGE_FILE_TYPE_LIST
/**$
	Get the export image file extension list
	Parameters:
		saImgTypes = [output] to get the type list
	Return:
		Returns TRUE for success, otherwise FALSE.
*/
bool get_export_image_types(StringArray& saImgTypes);
///end GET_IMAGE_FILE_TYPE_LIST
/// Hong 9/13/06 GET_FILE_LIST
/**$
	Seperate the string to get file list, the string is combine with \r\n or \n
	Parameters:
		lpcszStr = [Input] The string will be seperated.
		vsFiles  = [Output] to get the file list. 
		nInvalidFile = [Output] the first invalid file's index in string array
	Return:
		Returns the size of string vector
*/
/// Hong 10/30/06 ADD_SOPPURT_FIRST_INVALID_FILE_INDEX
//int separate_multiline_files(LPCSTR lpcszStr, vector<string>& vsFiles);
int separate_multiline_files(LPCSTR lpcszStr, vector<string>& vsFiles, int* pnInvalidFile = NULL);
/// end ADD_SOPPURT_FIRST_INVALID_FILE_INDEX
/// end GET_FILE_LIST
///Jasmine 10/13/06 GET_FILE_EXT_DESC
/**$
	Seperate file extension and description from the file type string
	Parameters:
		lpcszFiletype 	= [Input] The file type string. the format should follow syntax of LabTalk FDLog.TypeN$ object property. For example, [Workbook Template (*.otw)] *.otw
		strExt 			= [Output] to get the file extension, such as *.otw.
		pstrDesc		= [Output] string pointer to get the file description, such as Workbook Template .
		bUpper			= [Input] true will converts strExt to uppercase, else lowercase.
	Return:
		Returns false if lpcszFiletype has bad format, else return s true
*/
bool get_file_ext_desc(LPCSTR lpcszFiletype, string& strExt, string* pstrDesc = NULL, bool bUpper = false);
///End GET_FILE_EXT_DESC

///Cheney 2006-11-10 MOVE_IS_EMPTY_OR_UNASSIGN_FROM_EXPASC
// Category last updated by Hong 07/29/08 add $
/**$ >Character and String Manipulation
	Check string if is empty or equal to <unassigned> 
	Parameters:
		lpcsz = [input] input string.
	Return:
		Returns TRUE when string is empty or equal to <unassigned>, otherwise FALSE.
*/
bool is_empty_or_unassigned(LPCSTR lpcsz);
///end MOVE_IS_EMPTY_OR_UNASSIGN_FROM_EXPASC


//Comments last updated by Joseph on 2007.5.22
///Jasmine 12/12/06 FIND_CONTIGUOUS_RANGE
// Comment last updated by Hong 07/29/08
/**$
*/
int find_contiguous_range(const vector<int>& vn, int nValue, vector<uint>& uBegins, vector<uint>& uEnds);
// Category last updated by Hong 07/29/08 add #
/**$	>Character and String Manipulation
	Parameters:
	vn = 	  [Input] Vector where nValue to be search in
	nValue =  [Input] Integer to be found
	uBegins = [Output]Begin indeces of each range 
	uEnds =   [Output]End indeces of each range
	
	Example:
	void test_find_contiguous_range()
	{
		vector<int> vv = {6, 1, 6, 6, 2, 3, 4, 6, 5, 6, 6, 7, 8, 9, 0, 6};
		vector<uint> uBegins, uEnds;
		int nFind = find_contiguous_range(vv, 6, uBegins, uEnds);
		//-->uBegins = {0, 2, 7, 9, 15}, uEnds = {0, 3, 7, 10, 15}
	}
	
	Return:
		Return -1 or 0 if not find nValue in vn, else return the range number.
*/
//------ Folger 01/18/08 SHOULD_SORT_INPUT_VECTOR_BEFORE_FIND_CONTIGUOUS_RANGE
//int find_contiguous_range(const vector<uint>& vnIndeces, vector<uint>& uBegins, vector<uint>& uEnds);
int find_contiguous_range(vector<uint> vnIndeces, vector<uint>& uBegins, vector<uint>& uEnds);
//------
///End FIND_CONTIGUOUS_RANGE

// Comment last updated by Hong 07/29/08
/**$
*/
void show_time(LPCSTR lpcsz);//---- CPY 4/23/07 GRAPH_EXPORT_SPEED_TESTING

//----Jake 05/23/07 GET_SAVE_PATH_FROM_ORIGIN_INI
// Category last updated by Iris on 07/28/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:get_file_group_default_path_(global_function)
*/
string get_file_group_default_path(LPCSTR lpcszFileGroup,bool bSavePath = true);///Jake 06/05/07 CHANGE_FUNCTION_NAME
//----end GET_SAVE_PATH_FROM_ORIGIN_INI

//bool set_file_group_default_path(LPCSTR lpcszFileGroup, LPCSTR lpcszFilePath, bool bSavePath = true);	///Folger 06/13/07 SET_FILE_GROUP_DEFAULT_PATH

/// Iris 07/03/2007 v8.0654 USAGE_OF_BROWSER_COMBO_NOT_CONSISTENT_IN_FILE_AND_PATH_CONTROL
////----Jake 06/18/07 v8.0643 GET_PATH_TRACK_LIST_FROM_REGISTRY
//int get_path_list(LPCSTR lpcszXFDlgName, vector<string>& vsPathList,bool bOnlyRecent = false);
#define		STR_RELATIVE_PATH_SEP		_L("/")
int get_path_list(LPCSTR lpcszXFDlgName, vector<string>& vsPathList, bool bIncSpecialFolder = true, LPCSTR lpcszFilename = NULL);
////end GET_PATH_TRACK_LIST_FROM_REGISTRY
///end USAGE_OF_BROWSER_COMBO_NOT_CONSISTENT_IN_FILE_AND_PATH_CONTROL

//----Jake 06/18/07 v8.0643 UPDATE_PATH_TRACK_LIST_TO_REGISTRY
//void update_recent_path_list(LPCSTR lpcszXFDlgName, LPCSTR lpcszNewPath, int nMaxPathNum = 10);
void update_recent_path_list(LPCSTR lpcszNewPath, LPCSTR lpcszClassName = NULL, int nMaxPathNum = 10);
//end UPDATE_PATH_TRACK_LIST_TO_REGISTRY

//----Jake 06/19/07 v8.0644 CONVERT_PREDEFINED_PATH_TO_REAL_PATH
enum
{
	CVT_RELATIVE_PATH_ERR_SEP = 1,
	
	CVT_RELATIVE_PATH_LAST_ITEM
};
string cvt_predefined_path_to_real_path(LPCSTR lpcszPredefinedPath, int* pErrInfo = NULL);
//end CONVERT_PREDEFINED_PATH_TO_REAL_PATH

/// Iris 07/03/2007 v8.0654 USAGE_OF_BROWSER_COMBO_NOT_CONSISTENT_IN_FILE_AND_PATH_CONTROL
bool	str_is_predefined_path(LPCSTR lpcszPath, int* pnTypeID = NULL, string* pstrSubFolder = NULL, int* pErrInfo = NULL);

void	check_relative_path(LPCSTR lpcszPath, bool bPathWithoutFilename = true, string* pstrErr = NULL, bool* pbOKEnable = NULL);
///end USAGE_OF_BROWSER_COMBO_NOT_CONSISTENT_IN_FILE_AND_PATH_CONTROL

///---Sim 07-17-2007 IMPROVE_FILTER_SETTING_FUNC
enum
{
	FILTER_SETTING_DRAG_AND_DROG = 0,
};
///---END IMPROVE_FILTER_SETTING_FUNC

//---Jake 07/12/07 GET_AND_SET_FILTER_SETTING
/// Hong 08/14/07 QA80-9015 ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
//bool get_filter_setting(LPCSTR lpcszFilterName, bool& bValue, bool bSystemFolder = true, int nType = FILTER_SETTING_DRAG_AND_DROG);
//bool set_filter_setting(LPCSTR lpcszFilterName, bool bValue, bool bSystemFolder = true, int nType = FILTER_SETTING_DRAG_AND_DROG);
typedef enum
{
	FILTER_LOCATION_USER_FOLDER,
	FILTER_LOCATION_SYSTEM_FOLDER,
	FILTER_LOCATION_GROUP_FOLDER,
}FILTER_LOCATION;
//------ Folger 08/21/07 ADD_FILE_PATH_PARAM_TO_SPECIFY_GROUP_PATH
//bool get_filter_setting(LPCSTR lpcszFilterName, bool& bValue, int nLocation = FILTER_LOCATION_USER_FOLDER, int nType = FILTER_SETTING_DRAG_AND_DROG);
//bool set_filter_setting(LPCSTR lpcszFilterName, bool bValue, int nLocation = FILTER_LOCATION_USER_FOLDER, int nType = FILTER_SETTING_DRAG_AND_DROG);
bool get_filter_setting(LPCSTR lpcszFilterName, bool& bValue, int nLocation = FILTER_LOCATION_USER_FOLDER, int nType = FILTER_SETTING_DRAG_AND_DROG, LPCSTR lpcszFilePath = NULL);
bool set_filter_setting(LPCSTR lpcszFilterName, bool bValue, int nLocation = FILTER_LOCATION_USER_FOLDER, int nType = FILTER_SETTING_DRAG_AND_DROG, LPCSTR lpcszFilePath = NULL);
//------ End ADD_FILE_PATH_PARAM_TO_SPECIFY_GROUP_PATH
/// end ADD_GROUP_FOLDER_INTO_SEARCH_LIST_FOR_DRAG_AND_DROP
//---end GET_AND_SET_FILTER_SETTING

//------ Folger 08/21/07 REMOVE_ONE_LINE_FROM_FILTER_INI_SETTING
bool remove_line_from_filter_setting(LPCSTR lpcszFilterName, int nLocation = FILTER_LOCATION_USER_FOLDER, int nType = FILTER_SETTING_DRAG_AND_DROG, LPCSTR lpcszFilePath = NULL);
//------ End REMOVE_ONE_LINE_FROM_FILTER_INI_SETTING

//------ Folger 09/04/07 USE_FILE_LAST_MODIFIED_COMPARE_OF_VC_LEVEL
////------ Folger 08/23/07 COMPARE_TWO_FILES_MODIFIED_TIME
//bool file_modified_time_compare(string strFile1, string strFile2);
////------ End COMPARE_TWO_FILES_MODIFIED_TIME
//------ End USE_FILE_LAST_MODIFIED_COMPARE_OF_VC_LEVEL

//------ Folger 01/14/08 GET_ORIGIN75_SYSTEM_FILE_PATH
//bool get_origin75_user_path(string& strUserFilePath);//------ CPY 9/1/2007 CLEAN_UP_CODE_RELATED_TO_GETTING_75_FDF_FILES
bool get_origin75_user_path(string& strUserFilePath, bool bUser = true);
//------

//----- CPY 12/26/07 QA70-10870 NUMERIC_INPUT_BOX_NEEDED
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:InputBox_(global_function)
*/
double InputBox(double dDefault, LPCSTR lpcszMsg=NULL);
//-----

//------ Folger 04/17/08 QA80-11440 SYSTEM_UTILITY_FUNCTION_TO_REFRESH_ORIGIN_MAIN_MENU
bool	refresh_origin_main_menu();
//------

/// Iris 5/07/2008 ADD_CLASS_FOR_COL_LIST
// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:convert_int_vector_to_string_vector_(global_function)
*/
int 	convert_int_vector_to_string_vector(const vector<int>& vn, vector<string>& vs);

// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:convert_string_vector_to_int_vector_(global_function)
*/
int 	convert_string_vector_to_int_vector(const vector<string>& vs, vector<int>& vn, int nNoNumericReplace = -1);

// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:convert_uint_vector_to_string_vector_(global_function)
*/
int 	convert_uint_vector_to_string_vector(const vector<uint>& vn, vector<string>& vs);

// Category last updated by Hong 07/29/08
/**$ >Data Conversion
		convert string vector to uint vector
	Parameters:
		vs = [input] string array want to convert
		vn = [output] uint array wanted
		nNoNumericReplace = [input] Use this value to replace if item is not numeric. Default is 0 if not specify
	Return:
		the number of converted items
*/
int 	convert_string_vector_to_uint_vector(const vector<string>& vs, vector<uint>& vn, int nNoNumericReplace = 0);

// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:convert_byte_vector_to_string_vector_(global_function)
*/
int 	convert_byte_vector_to_string_vector(const vector<byte>& vn, vector<string>& vs);

// Category last updated by Hong 07/29/08
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:convert_string_vector_to_byte_vector_(global_function)
*/
int 	convert_string_vector_to_byte_vector(const vector<string>& vs, vector<byte>& vn, int nNoNumericReplace = 0);


///end ADD_CLASS_FOR_COL_LIST


//------ Folger 06/05/08 OPX_FILE_PUBLISH_SHOULD_IDENTIFY_BY_VERSION_FIRST
// Category last updated by Iris on 07/28/2008, added $
/**$
	Return :
		return -3 if either file does not existed
		return -2 if either file structure error
		return -1 if file2 version > f1 version
		return 1 if file1 version > file2 version
		return 0 if file2 and file has same version
*/
int opx_file_version_compare(LPCSTR lpcszFile1, LPCSTR lpcszFile2);
//------ End OPX_FILE_PUBLISH_SHOULD_IDENTIFY_BY_VERSION_FIRST

//------ Folger 08/22/08 QA80-12074 ADD_UTILITY_FUNCTION_FOR_INITIAL_TEMPLATE_LIST
enum{
	TEMPLATE_WORKSHEET	= 0x0001,
	TEMPLATE_MATRIX		= 0x0002,
	TEMPLATE_PLOT		= 0x0004,
};
bool init_template_list(TreeNode& trTemplate, DWORD dwType = TEMPLATE_WORKSHEET);
//------

///Jasmine 10/23/08 QA80-12442 SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE
/**$
	if fail to save lpcszFile, you can use this function to popup error message
*/
void popup_errmsg_save_readonly_file(LPCSTR lpcszFile, HWND hwnd = NULL);
//End SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE

///---Sim 12-23-2008 QA80-12836 SUPPORT_FILE_BROWSER_BUTTON
string get_open_dlg_file_filter(LPCSTR lpcszDescription, LPCSTR lpcszExtension);
///---END QA80-12836 SUPPORT_FILE_BROWSER_BUTTON


///Kyle 01/04/2009 QA70-12890-P4 CENTRALIZE_CODE_TO_GET_AND_UPDATE_CUSTOM_DATE_FORMAT

///Kyle 01/05/2009 QA70-12890-P6 CUSTOM_DATE_FORMAT_LIST_DEFAULT_SHOW_STANDARD_FORMAT_IN_SQL_CONVERT
//#define STR_CUSTOM_DATE_FORMAT_LIST_DEFAULT		"d'/'M'/'yyyy|yy'-'MM'-'dd|dd'.'MM'.'yyyy|yyyy'/'MM'/'dd|d'/'M'/'yyyy hh':'mm':'ss|dd'.'MM'.'yyyy hh':'mm':'ss|yy'-'MM'-'dd hh':'mm':'ss'.'####|yyyy'/'MM'/'dd hh':'mm':'ss'.'####"
//----- CPY 5/21/09 QA70-13649 CUSTOM_DATE_FORMAT_INIT_FROM_EXE_INI
// so we should use a shorter list but allows Noho people to customize, also, these const should not be put into sys_utils.h since they are used only in one c file, so I have moved to all inside c
//#define STR_CUSTOM_DATE_FORMAT_LIST_DEFAULT		"dd'/'MM'/'yyyy|dd'.'MM'.'yy|dd'-'MM'-'yy|MM'/'dd'/'yyyy|MM'-'dd'-'yy|yy'/'MM'/'dd|yy'.'MM'.'dd|yyyyMMdd|yyyy'-'MM'-'dd hh':'mm':'ss|yyyy'-'MM'-'dd hh':'mm':'ss'.'###"
//#define CUSTOM_DATE_FORMAT_LIST_MAX_NUM			10
//-----
/**$
	get the custom date format list from ini file, will get default list( STR_CUSTOM_DATE_FORMAT_LIST_DEFAULT ) if no list in the file
	return number of formating in list.
*/
int get_custom_date_format_list(vector<string>& vsList);

/**$
	return
		0 		means update successfully
		<0		error
		>0		no error and no need to update the list
*/
int update_custom_date_format_last_used(LPCSTR lpcszFormat);
///End CENTRALIZE_CODE_TO_GET_AND_UPDATE_CUSTOM_DATE_FORMAT

///------ Folger 03/26/09 ANALYSIS_OUTPUT_REPORT_SHEET_NAME_SHOULD_BE_EXCLAMATION_CHAR_ENDING
void		check_add_ending_char(string& str, char nChar);
string		convert_str_with_exclamation_char_endding(LPCSTR lpcsz);
///------ End ANALYSIS_OUTPUT_REPORT_SHEET_NAME_SHOULD_BE_EXCLAMATION_CHAR_ENDING

/// Hong 04/07/09 QA80-13419 GET_DEBUG_VECTOR_TREENODE_DISPLAY_STRING
/**$
*/
string get_display_string(const vector<string>& vstr, int nDisplayNum = 3, LPCSTR lpcszSep = ",");
/// end GET_DEBUG_VECTOR_TREENODE_DISPLAY_STRING

///---Sim 05-07-2009 QA80-13571 FIX_CRASH_WHEN_FILE_PATH_LENGTH_IS_TOO_LONG
/**$
	strFullFilePath = [input/output] file path, auto correct (trim) if too long	

	return true if too long
*/
bool check_trim_file_path_if_too_long(string& strFullFilePath, int nMaxPath = MAX_PATH);
///---END QA80-13571 FIX_CRASH_WHEN_FILE_PATH_LENGTH_IS_TOO_LONG

///------ Folger 08/10/09 QA80-13998 ACTIVE_SUMMARY_BOOK_ONLY_IF_IN_ACTIVE_FOLDER
bool	is_same_folder(Folder fld1, Folder fld2);
///------ End ACTIVE_SUMMARY_BOOK_ONLY_IF_IN_ACTIVE_FOLDER

///------ Folger 08/27/09 QA80-14215 CHANGE_USER_FILES_FOLDER_IN_ORIGIN
BOOL	is_path_writable(LPCSTR lpcszFilePath);
///------ End CHANGE_USER_FILES_FOLDER_IN_ORIGIN

///---Sim 08-31-2009 QA81-14106 IMPROVE_ED_DIALOG
/**$
*/
int string_array_find_one_of(const StringArray& saDests, const StringArray& saRefs, int nStart = 0, int *pIndexOnArr = NULL);
///---END QA81-14106 IMPROVE_ED_DIALOG

///------ Folger 10/21/09 QA81-14506 FAILS_TO_IMPORT_CSV_FILE_IN_SAMPLES_FOLDER_UNDER_GOS_BY_DEFAULT
BOOL	is_builtin_sample_file(LPCSTR lpcszFile);
///------ End FAILS_TO_IMPORT_CSV_FILE_IN_SAMPLES_FOLDER_UNDER_GOS_BY_DEFAULT

///------ Folger 10/28/09 QA81-14541 SYSTEM_DEFAULT_FILE_EXTENSION_TEMP_CHANGE_SUPPORT
#define		INVALID_FILE_EXT_DEFAULT_TYPE		-1
class SystemDefaultFileExtTempChange
{
public:
	SystemDefaultFileExtTempChange(LPCSTR lpcszGroup, int nDefaultType = INVALID_FILE_EXT_DEFAULT_TYPE);
	~SystemDefaultFileExtTempChange();

private:

	void	changeStr(LPCSTR lpcszKey, LPCSTR lpcszSet, string& strSaved = NULL);	
	void	changeInt(LPCSTR lpcszKey, int nSet, int& nSaved = NULL);

private:
	OriginSettings	m_os;
	string			m_strActiveGroupKey;
	string			m_strDefaultTypeKey;
	string			m_strActiveGroup;
	int				m_nDefaultType;
};
///------ End SYSTEM_DEFAULT_FILE_EXTENSION_TEMP_CHANGE_SUPPORT

///------ Folger 07/12/10 ORG-532 TRANSFER_USER_FILES_FAILED_TO_SHOW_81_FILES
#define CURRENT_VERSION			__Current_Version(2)
double	__Current_Version(UINT nDecimalPlaces);
///------ End TRANSFER_USER_FILES_FAILED_TO_SHOW_81_FILES

#endif //_SYS_UTILS_H
